 ; Ŀ
 ;   Hvb - Horizontal Venetian Blind                                       
 ;   Copyright 1991, 1997, 2007 by Rocket Software Ltd.                    
 ;   Multiple text realigner - moves text to a common Y co-ordinate        
 ;   without altering its X position.                                      
 ;                                                                         
 ;   The Left/Right/ML/MR options are useful for aligning 90 degree        
 ;   rotated text which is not left justified but should have been.        
 ;                                                                         
 ;   Also contains:                                                        
 ;   Hm: horizontal rejustify middle.                                      
 ;   Hml: horizontal rejustify middle left.                                
 ;   Hmr: horizontal rejustify middle right.                               
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Hvmm - rejustify and realign an ss of text/attdefs.        
 ;   Arguments: Subba, the rejustify routine to call.                      
 ;              Tenpt, the insertion point association number - 10 or 11.  
 ;              ss,    the selection set of text and attdefs.              
 ;              Xa,    the insertion level (Y coordinate.)                 
 ;   Calls the said routine, returns nothing.                              
 ; 
 (DEFUN HVMM (subba tenpt ss xa / num enam entt inspt newpt)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         ((eval subba) enam)
         (setq entt (entget enam))
         (setq inspt (cdr (assoc tenpt entt)))
         (setq newpt (list (car inspt) xa))
         (command "move" enam "" inspt newpt))
 (princ))
 ; Ŀ
 ;   Subroutine Hvmm end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Hvmmer - rejustify and realign text/attdefs.               
 ;   Arguments: Subba, the rejustify routine to call.                      
 ;   Calls Hvmm which calls the said routine, returns nothing.             
 ;   A routine that has nothing to do with SUVs or the Roman empire.       
 ; 
 (DEFUN HVMMER (subba / osmo *error* ss xa)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (command ".undo" "end")
   (if shk (write-line shk))
  (princ))
  (prompt "Pick text strings:")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
  (setq xa (cadr (getpoint "\nInsertion level: ")))
  (setvar "osmode" 0)
  (hvmm subba 11 ss xa)
  (*error* ())
 (princ))
 ; Ŀ
 ;   Subroutine Hvmmer end.                                                
 ; 

 ; Ŀ
 ;   Mrrj - middle right rejustify a text or attdef entity, preserve the   
 ;   location.                                                             
 ; 
 (DEFUN MRRJ (enam / entt typ pta pa pta1 p11 ydis new11)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (setq pta (cdr (assoc 10 entt)))
  (if (= typ "TEXT")
      (if (assoc 73 entt)
          (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
          (setq entt (append entt (list (cons 73 2)))))
      (if (assoc 74 entt)
          (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
          (setq entt (append entt (list (cons 74 2))))))
  (entmod (setq entt (subst (cons 72 2) (assoc 72 entt) entt)))
  (setq entt (entget enam))
  (setq pta1 (cdr (assoc 10 entt)))
  (setq p11 (cdr (assoc 11 entt)))
  (setq xdis (- (car pta) (car pta1)))
  (setq ydis (- (cadr pta) (cadr pta1)))
  (setq new11 (list (+ (car p11) xdis) (+ (cadr p11) ydis) (caddr p11)))
  (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   Mrrj end.                                                             
 ; 

 ; Ŀ
 ;   MLrj - middle left rejustify a text or attdef entity, preserve the    
 ;   location.                                                             
 ; 
 (DEFUN MLRJ (enam / entt typ pta pa pta1 p11 ydis new11)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (setq pta (cdr (assoc 10 entt)))
  (if (= typ "TEXT")
      (if (assoc 73 entt)
          (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
          (setq entt (append entt (list (cons 73 2)))))
      (if (assoc 74 entt)
          (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
          (setq entt (append entt (list (cons 74 2))))))
  (entmod (setq entt (subst (cons 72 0) (assoc 72 entt) entt)))
  (setq entt (entget enam))
  (setq pta1 (cdr (assoc 10 entt)))
  (setq p11 (cdr (assoc 11 entt)))
  (setq xdis (- (car pta) (car pta1)))
  (setq ydis (- (cadr pta) (cadr pta1)))
  (setq new11 (list (+ (car p11) xdis) (+ (cadr p11) ydis) (caddr p11)))
  (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   MLrj end.                                                             
 ; 

 ; Ŀ
 ;   Midd - middle rejustify a text entity, preserve the location.         
 ; 
 (DEFUN MIDD (enam / entt ten eleven new10 dist angl new11 nu11)
  (setq entt (entget enam))
  (setq ten (cdr (assoc 10 entt)))
  (setq eleven (cdr (assoc 11 entt)))
  (entmod (subst (cons 72 4) (assoc 72 entt) entt))    ; change
  (setq entt (entget enam))                            ; get the changed edata
  (setq new10 (cdr (assoc 10 entt)))                   ; new 10 point
  (setq dist (distance ten new10))                     ; distance moved
  (setq angl (angle new10 ten))                        ; and angle
  (setq new11 (cdr (assoc 11 entt)))                   ; new centre point
  (setq nu11 (polar new11 angl dist))             ; move centre same as 10 was
  (entmod (subst (cons 11 nu11) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   Midd end.                                                             
 ; 

 ; Ŀ
 ;   Rite - right rejustify a text entity, preserve the location.          
 ; 
 (DEFUN RITE (enam / entt typ ten0 ten1)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (setq ten0 (cdr (assoc 10 entt)))
  (if (= typ "ATTDEF")
      (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
      (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
  (entmod (subst (cons 72 2) (assoc 72 entt) entt))
  (setq entt (entget enam))
  (setq ten1 (cdr (assoc 10 entt)))
  (command "move" enam "" ten1 ten0)
 (princ))
 ; Ŀ
 ;   Rite end.                                                             
 ; 

 ; Ŀ
 ;   Bleft - left rejustify a text entity.                                 
 ; 
 (DEFUN BLEFT (enam / entt)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (if (= typ "ATTDEF")
      (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
      (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
  (entmod (subst (cons 72 0) (assoc 72 entt) entt))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Bleft end.                                                            
 ; 

 ; Ŀ
 ;   Hvb.                                                                  
 ; 
 (DEFUN C:HVB ( / osmo *error* ss xa num ll enam inspt newpt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (command ".undo" "end")
   (if shk (write-line shk))
  (princ))
  (prompt "Pick text strings:")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
  (setq xa (cadr (getpoint "\nInsertion level: ")))
  (initget "Left Right Middle ML MR Insertion")
  (setq ll (getkword "\nAlign text on Left/ML/Right/MR/Middle/<Insertion>: "))
  (setq num 0)
  (setvar "osmode" 0)
  (cond ((or (null ll) (= ll "Insertion"))
         (while (setq enam (ssname ss num))
                (setq num (1+ num))
                (setq entt (entget enam))
                (if (or (= (cdr (assoc 72 entt)) 2)
                        (= (cdr (assoc 72 entt)) 4)
                        (= (cdr (assoc 72 entt)) 1))
                    (progn
                         (setq inspt (cdr (assoc 11 entt)))
                         (setq newpt (list (car inspt) xa))
                         (command "move" enam "" inspt newpt))
                    (progn
                         (setq inspt (cdr (assoc 10 entt)))
                         (setq newpt (list (car inspt) xa))
                         (command "move" enam "" inspt newpt)))))
        ((= ll "Left")
         (hvmm 'bleft 10 ss xa))
        ((= ll "Middle")
         (hvmm 'midd 11 ss xa))
        ((= ll "ML")
         (hvmm 'mlrj 11 ss xa))
        ((= ll "MR")
         (hvmm 'mrrj 11 ss xa))
        ((= ll "Right")
         (hvmm 'rite 11 ss xa)))
  (*error* ())
 (princ))

 ; Ŀ
 ;   Hm.                                                                   
 ; 
 (DEFUN C:HM ()
  (hvmmer 'midd)
 (princ))

 ; Ŀ
 ;   Hml.                                                                  
 ; 
 (DEFUN C:HML ()
  (hvmmer 'mlrj)
 (princ))

 ; Ŀ
 ;   Hmr.                                                                  
 ; 
 (DEFUN C:HMR ()
  (hvmmer 'mrrj)
 (princ))

(princ)